/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads;

import com.google.common.collect.Lists;
import java.util.List;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.network.NetworkHandler;
import net.blay09.mods.cookingforblockheads.network.message.MessageSyncedEffect;
import net.blay09.mods.cookingforblockheads.tile.CowJarTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CowJarHandler {
    private static final List<Class<? extends LivingEntity>> additionalCowClasses = Lists.newArrayList();

    public static void registerCowClass(Class<?> clazz) {
        additionalCowClasses.add(clazz);
    }

    @SubscribeEvent
    public void onEntityDamage(LivingAttackEvent event) {
        if (!((Boolean)CookingForBlockheadsConfig.COMMON.cowJarEnabled.get()).booleanValue()) {
            return;
        }
        if (event.getSource() == DamageSource.field_82728_o && this.isCow(event.getEntityLiving())) {
            Entity entity = event.getEntity();
            BlockPos pos = entity.func_233580_cy_();
            World world = entity.func_130014_f_();
            BlockState blockBelow = world.func_180495_p(pos);
            if (blockBelow.func_177230_c() == ModBlocks.milkJar) {
                boolean wasCompressed;
                world.func_175656_a(pos, ModBlocks.cowJar.func_176223_P());
                TileEntity tileEntity = world.func_175625_s(pos);
                if (tileEntity instanceof CowJarTileEntity && entity.func_200201_e() != null) {
                    TranslationTextComponent textComponent = new TranslationTextComponent("container.cookingforblockheads.cow_jar_custom", new Object[]{entity.func_200201_e()});
                    ((CowJarTileEntity)tileEntity).setCustomName((ITextComponent)textComponent);
                }
                if ((wasCompressed = event.getEntity().getPersistentData().func_74775_l("excompressum").func_74767_n("Compressed")) && tileEntity instanceof CowJarTileEntity) {
                    ((CowJarTileEntity)tileEntity).setCompressedCow(true);
                }
            }
            NetworkHandler.sendToAllTracking(new MessageSyncedEffect(pos, MessageSyncedEffect.Type.COW_IN_A_JAR), entity);
            entity.func_70106_y();
            event.setCanceled(true);
        }
    }

    public boolean isCow(LivingEntity entity) {
        if (entity instanceof CowEntity) {
            return true;
        }
        for (Class<? extends LivingEntity> clazz : additionalCowClasses) {
            if (!clazz.isAssignableFrom(entity.getClass())) continue;
            return true;
        }
        ResourceLocation registryName = entity.func_200600_R().getRegistryName();
        return registryName != null && registryName.func_110623_a().contains("cow");
    }
}

